﻿namespace FAQ.Repository.Contracts
{
    public interface IQuestionRepository
    {
        /// <summary>
        /// Trouve et renvoie la liste des questions.
        /// </summary>
        List<Entities.Question> FindAll();

        /// <summary>
        /// Ajoute une nouvelle Question.
        /// </summary>
        /// <param name="Question">L'objet question à ajouter.</param>
        void Add(Entities.Question Question);

        /// <summary>
        /// Supprime une Question spécifique.
        /// </summary>
        /// <param name="Id">L'id question à supprimer.</param>
        void RemoveQuestion(int Id);

        /// <summary>
        /// Renvoie la dernière question.
        /// </summary>
        /// <returns>La dernière question.</returns>
        Entities.Question Last();

        /// <summary>
        /// Renvoie une liste de versions triées et date.
        /// </summary>
        /// <returns>Liste des versions triées.</returns>
        List<Entities.Question> OrderBy();
    }
}
